<?php
/* --------------------------------------------------------------------------------------*/
/* --------------------------------------------------------------------------------------*/
error_reporting (E_ALL ^ E_NOTICE); /* 1st line (recommended) */
header('Content-type: text/html; charset=utf-8');

include 'config.php';

// Make the connnection and then select the database.
$dbc = @($GLOBALS["___mysqli_ston"] = mysqli_connect(DB_HOST,  DB_USER,  DB_PASSWORD)) OR die ('Cannot connect to MySQL.');
((bool)mysqli_query($GLOBALS["___mysqli_ston"], "USE " . constant('DB_NAME_TEST'))) OR die ('Unable to select database.');
mysqli_query($GLOBALS["___mysqli_ston"], 'SET NAMES utf8');
/* --------------------------------------------------------------------------------------*/
/* --------------------------------------------------------------------------------------*/
$bookArray = Array();
$catArray = Array();
$wordArray = Array();
$appVersionArray = Array();
if(isset($_GET['book'])){
	$currentBook = cleanMe($_GET['book']);
	$sql = "SELECT * FROM units WHERE book = ? ORDER BY c_order";
	$stmt = $dbc->prepare($sql);
	$stmt->bind_param("s", $currentBook);
	$stmt->execute();
	//$units = $stmt->get_result();
	bind_array($stmt, $unit);
	while($stmt->fetch()) {
	  $row = Array();
	  $row['id'] = $unit['id'];
	  $row['num'] = $unit['num'];
	  $row['la_name'] = $unit['la_name'];
	  $row['eng_name'] = $unit['eng_name'];
	  $row['book'] = $currentBook;
	  if($unit['recog']!=""){
	  $row['recog'] = "https://s3-us-west-2.amazonaws.com/languageconservancy.org/ARFiles/recognition/".$unit['recog'];
	  }
	  else{
	  $row['recog'] = "";
	  }
	  $row['version'] = $unit['version'];
	  $catArray[] = $row;
	}

	$sql = "SELECT * FROM words WHERE book = ? ORDER BY id";
	$stmt = $dbc->prepare($sql);
	$stmt->bind_param("s", $currentBook);
	$stmt->execute();
	//$words = $stmt->get_result();
	bind_array($stmt, $word);
	while($stmt->fetch()) {
	  $row = Array();
	  $row['id'] = $word['id'];
	  $row['la'] = str_replace('\r\n', '', $word['la']);
	  $row['en'] = $word['eng'];
	  if($word['image'] != "") {
		$row['img'] = "https://s3-us-west-2.amazonaws.com/languageconservancy.org/ARFiles/images/".$word['image'];
	  } else {
		$row['img'] = null;
	  }
	  if($word['sound'] != "") {
		$row['sound'] = "https://s3-us-west-2.amazonaws.com/languageconservancy.org/ARFiles/audio/".LANG."/".$word['sound'];
	  } else {
		$row['sound'] = null;
	  }
	  $row['book'] = $currentBook;
	  $row['unit'] = $word['unit'];
	  $row['ar_only'] = $word['ar_only'];
	  $row['target'] = $word['target'];
	  $row['version'] = $word['version'];
	  $wordArray[] = $row;
	}

	$finalArray = Array();
	$finalArray["units"] = $catArray;
	$finalArray["words"] = $wordArray;
	$json = json_encode($finalArray, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
	echo $json;
	}
else{
	$currentBook = "";

	$sql = "SELECT * FROM books ORDER BY id";
	$stmt = $dbc->prepare($sql);
	$stmt->execute();
	//$units = $stmt->get_result();
	bind_array($stmt, $book);
	while($stmt->fetch()) {
	  $row = Array();
	  $row['id'] = $book['id'];
	  $row['name'] = $book['name'];
	  $row['img'] = "https://s3-us-west-2.amazonaws.com/languageconservancy.org/ARFiles/covers/".$book['img'];
	  $row['api'] = LANG_DOMAIN."api.php?book=".$book['id'];
	  $row['recog'] = "https://s3-us-west-2.amazonaws.com/languageconservancy.org/ARFiles/recognition/".$book['recog'];
	  $row['info'] = "https://s3-us-west-2.amazonaws.com/languageconservancy.org/ARFiles/info/".$book['info'];
	  $row['version'] = $book['version'];
	  $row['android_iap'] = $book['android_iap'];
	  $row['android_price'] = $book['android_price'];
	  $row['ios_iap'] = $book['ios_iap'];
	  $row['ios_price'] = $book['ios_price'];
	  $row['download_size'] = $book['download_size'];
	  $bookArray[] = $row;
	}
	$finalArray = Array();
	$finalArray["books"] = $bookArray;
	$json = json_encode($finalArray, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
	echo $json;

	}

function bind_array($stmt, &$row) {
    $md = $stmt->result_metadata();
    $params = array();
    while($field = $md->fetch_field()) {
        $params[] = &$row[$field->name];
    }

    call_user_func_array(array($stmt, 'bind_result'), $params);
}
function cleanMe($input) {
   $input = htmlspecialchars($input, ENT_IGNORE, 'utf-8');
   $input = strip_tags($input);
   $input = stripslashes($input);
   return $input;
}
?>
